/**
 * Wrapper for server
 * - acts as interface for communication with server
 * - other classes uses it's methods to do requests
 */
var Server = new Class({
  Implements: [Options],
  options: {
		url: settings.server_url,
    method: air.URLRequestMethod.POST,
    background: false // whether to show modal overlay or not - defaults to false (show overlay)
  },
  last_request: null,
  overlay: new Modalizer(),  
  
  initialize: function(options){
    this.setOptions(options);
  },
  
  // shows window overlay and loader icon
  showLoader: function(){
    this.overlay.modalShow({
      hideOnClick: false,
      modalStyle: {
        position: 'fixed'
      },
      onModalShow: $empty,
      onModalHide: $empty,
    });
  },
  
  hideLoader: function(){
    this.overlay.modalHide();
  },
	
	// private
	createRequest: function(options){
    var req = new air.URLRequest(); 
    req.useCache = false;
    req.cacheResponse = false;
    req.url = options.url; 
    req.method = options.method; 
    
    req.data = new air.URLVariables();
		return req;
	},
  
  request: function(data, onComplete, options){
		// override default options
		options = $merge(this.options, options);
		
    if(!options.background) this.showLoader()
		
		var req = this.createRequest(options);
		req.data.request = JSON.encode(data); 

    var loader = new air.URLLoader(); 
    loader.dataFormat = air.URLLoaderDataFormat.TEXT; 
		
    loader.addEventListener(air.Event.COMPLETE, function(event){
			this.onCompleteHandler(event.target.data, options, onComplete);
		}.bind(this)); 
		
    try { 
      loader.load(req); 
    } catch (error) { 
      air.trace("Unable to load URL");  
      air.trace(error);
      if(!options.background) this.hideLoader();
    }      
  },
	
	uploadFile: function(data, filepath, onComplete, onProgressUpdate, onError, options){
    // override default options
    options = $merge(this.options, options);
    
    if(!options.background) this.showLoader()
    
		var req = this.createRequest(options);
    req.data.request = JSON.encode(data);
		 
		var file = new air.File(filepath); 
		
		if ($defined(onProgressUpdate)) file.addEventListener(air.ProgressEvent.PROGRESS, onProgressUpdate);
    
    if ($defined(onError)) {
			var onErrorHandler = function(event){
		    if(!options.background) this.hideLoader();
		    if($defined(onError)) onError(event);
      }.bind(this);
			
			file.addEventListener(air.SecurityErrorEvent.SECURITY_ERROR, onErrorHandler);
      file.addEventListener(air.HTTPStatusEvent.HTTP_STATUS, onErrorHandler);
			file.addEventListener(air.IOErrorEvent.IO_ERROR, onErrorHandler);
		}
		
    file.addEventListener(air.DataEvent.UPLOAD_COMPLETE_DATA, function(event){
      this.onCompleteHandler(event.data, options, onComplete);
    }.bind(this)); 
    
    try { 
      file.upload(req, 'filedata', false); 
    } catch (error) { 
      air.trace("Unable to upload file"); 
			air.trace(error);
      if(!options.background) this.hideLoader();
    }
	},
	
	downloadFile: function (url, file, onComplete, onProgressUpdate, onError, options) {
    // override default options
    options = $merge(this.options, options);
    
    if(!options.background) this.showLoader()
    
		var urlStream = new air.URLStream();
		var request = new air.URLRequest(url);
		var fileStream = new air.FileStream();
    fileStream.openAsync(file, air.FileMode.WRITE);   
		
		urlStream.addEventListener(air.Event.COMPLETE, function(event){
      this.writeFile(urlStream, fileStream, true);
      fileStream.close();
      urlStream.close();
			
	    if (!options.background) this.hideLoader();
	    if ($defined(onComplete)) onComplete(event);
		}.bind(this));
		
    var onErrorHandler = function(event){
      if(!options.background) this.hideLoader();
      if($defined(onError)) onError(event);
    }.bind(this);
		
    urlStream.addEventListener(air.SecurityErrorEvent.SECURITY_ERROR, onErrorHandler);
    urlStream.addEventListener(air.IOErrorEvent.IO_ERROR, onErrorHandler);
		
		urlStream.addEventListener(air.ProgressEvent.PROGRESS, function(event){
      this.writeFile(urlStream, fileStream, false);
			if ($defined(onProgressUpdate)) onProgressUpdate(event);  
		}.bind(this));
		
    try { 
      urlStream.load(request); 
    } catch (error) { 
      air.trace("Unable to download file"); 
      air.trace(error);
      if(!options.background) this.hideLoader();
    }
  },
	
	// private
  // write 50k from the urlstream to the filestream, unless
  // the writeAll flag is true, when we write everything in the buffer
  writeFile: function(urlStream, fileStream, writeAll) {
    if (urlStream.bytesAvailable > 51200 || writeAll) {
      var dataBuffer = new air.ByteArray();
      urlStream.readBytes(dataBuffer, 0, urlStream.bytesAvailable);
      fileStream.writeBytes(dataBuffer, 0, dataBuffer.length);
    }
  },
  
	// private
  onCompleteHandler: function(data, options, onComplete){
    var response = null;
    try {
      response = JSON.decode(data);
    } catch(e){
      trace("Wrong response:");
      trace(data);
    }
    
    if($defined(response) && $defined(response.error)){
      response.error.message = decodeURIComponent(response.error.message);
      trace("Response error #"+response.error.code+": "+response.error.message);
      showError(response.error.message);
    }
    
    if (!options.background) this.hideLoader();
    if ($defined(onComplete)) onComplete(response);
  }
});